//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// MarshalDlg.cpp : plik implementacji
//

#include "stdafx.h"
#include "Marshal.h"
#include "MarshalDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// Okno dialogowe CAboutDlg wykorzystywane przez App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dane okna dialogowego
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // Obsuga DDX/DDV

// Implementacja
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// Okno dialogowe CMarshalDlg



CMarshalDlg::CMarshalDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMarshalDlg::IDD, pParent)
	, operand1(0)
	, operand2(0)
	, result(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMarshalDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT1, operand1);
	DDX_Text(pDX, IDC_EDIT2, operand2);
	DDX_Text(pDX, IDC_EDIT3, result);
}

BEGIN_MESSAGE_MAP(CMarshalDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_ADD, OnClickedAdd)
	ON_BN_CLICKED(IDC_SUBTRACT, OnClickedSubtract)
	ON_BN_CLICKED(IDC_MULTIPLY, OnClickedMultiply)
	ON_BN_CLICKED(IDC_DIVIDE, OnClickedDivide)
END_MESSAGE_MAP()


// Procedury obsugi wiadomoci CMarshalDlg

BOOL CMarshalDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Dodanie elementu menu "O programie..." do menu systemowego.

	// IDM_ABOUTBOX musi znajdowa si w zasigu polece systemowych.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Ustawienie ikonki dla tego okna dialogowego. Struktura wykonuje to automatycznie,
	//  jeli gwne okno aplikacji nie jest oknem dialogowym.
	SetIcon(m_hIcon, TRUE);			// Ustawienie duej ikonki
	SetIcon(m_hIcon, FALSE);		// Ustawienie maej ikonki

	HRESULT hr = basicOperations.CoCreateInstance(__uuidof(Arithmetic::Arithmetic));
	if(FAILED(hr))
		return FALSE;
	
	return TRUE;  // zwrcenie TRUE, chyba e ognisko ustawiono na element sterujcy
}

void CMarshalDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// Jeli do okna dialogowego zostanie dodany przycisk minimalizacji, poniszy kod bdzie niezbdny
//  do przecigania ikonki. W przypadku aplikacji MFC korzystajcych z modelu dokument/widok
//  zostanie to wykonane automatycznie przez struktur.

void CMarshalDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // kontekst urzdzenia sucy do rysowania

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Wyporodkowanie ikonki w prostokcie klienta
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Rysowanie ikonki
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// System wywouje t funkcj w celu uzyskania wskanika, kiedy uytkownik przeciga
//  zminimalizowane okno.
HCURSOR CMarshalDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CMarshalDlg::OnClickedAdd()
{
	UpdateData(TRUE);
	result = basicOperations->Add(operand1, operand2);
	UpdateData(FALSE);
}

void CMarshalDlg::OnClickedSubtract()
{
	UpdateData(TRUE);
	result = basicOperations->Subtract(operand1, operand2);
	UpdateData(FALSE);
}

void CMarshalDlg::OnClickedMultiply()
{
	UpdateData(TRUE);
	result = basicOperations->Multiply(operand1, operand2);
	UpdateData(FALSE);
}

void CMarshalDlg::OnClickedDivide()
{
	UpdateData(TRUE);
	result = basicOperations->Divide(operand1, operand2);
	UpdateData(FALSE);
}
